IF  EXISTS (SELECT * FROM sys.objects 
            WHERE object_id = OBJECT_ID(N'[dbo].[UFD_EST_PROD_CONVERTE_EMBALAGEM]') 
            AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))

/****** Object:  UserDefinedFunction [dbo].[UFD_EST_PROD_CONVERTE_EMBALAGEM]    Script Date: 14/08/2013 16:42:21 ******/
DROP FUNCTION [dbo].[UFD_EST_PROD_CONVERTE_EMBALAGEM]
GO
--SELECT * FROM UFD_EST_PROD_CONVERTE_EMBALAGEM (1,44,58413,18,471.61,0)
CREATE FUNCTION UFD_EST_PROD_CONVERTE_EMBALAGEM  (@CD_EMP INT, 
												  @CD_FORN INT, 
												  @CD_PROD INT, 
												  @QT_PROD_CONV MONEY,
												  @VLR_PROD MONEY,
												  @FLAG_EMB_FORCADA INT,
												  @QT_EMB_FORCADA MONEY)
RETURNS @RETURN_REC 
TABLE(
	APRES_EMP_CP INT,
	APRES_QT_CP MONEY,
	APRESENTACAO VARCHAR(20),
	QT_PROD_CONV MONEY,
	VLR_UNITARIO MONEY,
	QTDE_CONVERTIDO MONEY,
	VLR_UNITARIO_CONVERTIDO MONEY,
	TP_COD INT,
	FLAG_NAO_CONVERTER_EMBALAGEM INT,
	FLAG_TIPO_CONVERSAO INT
)
AS 
BEGIN
DECLARE @APRES_EMP_CP INT
DECLARE @APRES_QT_CP MONEY
DECLARE @TP_COD INT
DECLARE @FLAG_NAO_CONVERTER_EMBALAGEM INT
DECLARE @FLAG_TIPO_CONVERSAO INT
DECLARE @QT_PROD_CONVERTIDO MONEY

SELECT 
	@APRES_EMP_CP = 1, 
	@APRES_QT_CP=@QT_EMB_FORCADA,
	@TP_COD=1,
	@FLAG_NAO_CONVERTER_EMBALAGEM= 0,
	@FLAG_TIPO_CONVERSAO=0 

IF @FLAG_EMB_FORCADA=0
BEGIN
SELECT 
	@APRES_EMP_CP = EST_PROD_FORN.APRES_EMB_CP, 
	@APRES_QT_CP=EST_PROD_FORN.APRES_QT_CP,
	@TP_COD=1,
	@FLAG_NAO_CONVERTER_EMBALAGEM= ISNULL(PG_FORN.FLAG_NAO_CONVERTER_EMBALAGEM,0),
	@FLAG_TIPO_CONVERSAO=ISNULL(FLAG_TIPO_CONVERSAO,0) 
FROM 
	EST_PROD_FORN INNER JOIN PG_FORN ON 
	EST_PROD_FORN.CD_EMP = PG_FORN.CD_EMP AND 
	EST_PROD_FORN.CD_FORN = PG_FORN.CD_FORN 
WHERE 
	EST_PROD_FORN.CD_EMP =@CD_EMP
	AND EST_PROD_FORN.CD_PROD =@CD_PROD
	AND EST_PROD_FORN.CD_FORN =@CD_FORN
END

IF @APRES_EMP_CP=0
BEGIN
	SELECT 
		 @APRES_EMP_CP = APRES_EMB_CP, 
	     @APRES_QT_CP=APRES_QT_CP,
		 @TP_COD=0, 
		 @FLAG_NAO_CONVERTER_EMBALAGEM=0,
		 @FLAG_TIPO_CONVERSAO=0
    FROM 
		 EST_PROD
    WHERE 
		CD_EMP = @CD_EMP    
		AND CD_PROD =@CD_PROD
END
INSERT INTO @RETURN_REC
SELECT 
	@APRES_EMP_CP,
	@APRES_QT_CP,
	CONVERT(VARCHAR(10),@APRES_EMP_CP) + ' x ' + CONVERT(VARCHAR(10),@APRES_QT_CP),
	@QT_PROD_CONV,
	@VLR_PROD,
	CASE WHEN @FLAG_TIPO_CONVERSAO=0 THEN  @QT_PROD_CONV * @APRES_QT_CP ELSE @QT_PROD_CONV / @APRES_QT_CP END,
	@VLR_PROD /CASE WHEN @FLAG_TIPO_CONVERSAO=0 THEN  @QT_PROD_CONV * @APRES_QT_CP ELSE @QT_PROD_CONV / @APRES_QT_CP END,
	@TP_COD,
	@FLAG_NAO_CONVERTER_EMBALAGEM,
	@FLAG_TIPO_CONVERSAO
RETURN
END